// Copyright 2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.controls {	
	
	/**
	 * The ButtonLabelPlacement class defines constants for the 
     * values of the <code>labelPlacement</code> property of a Button, 
	 * CheckBox, or RadioButton component.
     *
     * @includeExample examples/ButtonLabelPlacementExample.as
	 *
     * @see LabelButton#labelPlacement
     *
     * @langversion 3.0
     * @playerversion Flash 9.0.28.0
	 *  
	 *  @playerversion AIR 1.0

	 *  @productversion Flash CS3
	 */
	public class ButtonLabelPlacement {
		
		/**
         * The label appears below the icon.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const BOTTOM:String = "bottom";

		/**
         * The label appears above the icon.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const TOP:String = "top";

		/**
         * The label appears to the left of the icon.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const LEFT:String = "left";

		/**
         * The label appears to the right of the icon.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const RIGHT:String = "right";	
		
	}
}